import { world, system } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:pointed_icicle_sizes', {
        onTick({ block }) {
            const tip = block.permutation.withState("v360:size", 0)
            const frustum = block.permutation.withState("v360:size", 1)
            const middle = block.permutation.withState("v360:size", 2)
            const base = block.permutation.withState("v360:size", 3)
            const tip_merge = block.permutation.withState("v360:size", 4)
            if (block.hasTag('v360:bottom') && block.above().typeId !== 'v360:pointed_icicle_block') {
                block.setPermutation(tip)
            }
            else if (block.hasTag('v360:bottom') && block.above().hasTag('v360:bottom') && block.above().hasTag('v360:tip' || 'v360:tip_merge') && block.above().typeId === 'v360:pointed_icicle_block') {
                block.setPermutation(frustum)
            }
            else if (block.hasTag('v360:bottom') && block.above().hasTag('v360:frustum' || 'v360:bottom') && block.above().typeId === 'v360:pointed_icicle_block' && block.below().typeId === 'v360:pointed_icicle_block') {
                block.setPermutation(middle)
            }
            else if (block.hasTag('v360:bottom') && block.above().hasTag('v360:frustum' || 'v360:middle') && block.above().typeId === 'v360:pointed_icicle_block' && block.below().typeId !== 'v360:pointed_icicle_block') {
                block.setPermutation(base)
            }
            else if (block.hasTag('v360:bottom') && block.hasTag('v360:tip') && block.above().hasTag('v360:tip_merge') && block.above().hasTag('v360:top') && block.above().typeId === 'v360:pointed_icicle_block') {
                block.setPermutation(tip_merge)
            }
            else if (block.hasTag('v360:top') && block.below().typeId !== 'v360:pointed_icicle_block') {
                block.setPermutation(tip)
            }
            else if (block.hasTag('v360:top') && block.below().hasTag('v360:top') && block.below().hasTag('v360:tip' || 'v360:tip_merge') && block.below().typeId === 'v360:pointed_icicle_block') {
                block.setPermutation(frustum)
            }
            else if (block.hasTag('v360:top') && block.below().hasTag('v360:frustum' || 'v360:middle') && block.below().typeId === 'v360:pointed_icicle_block' && block.above().typeId === 'v360:pointed_icicle_block') {
                block.setPermutation(middle)
            }
            else if (block.hasTag('v360:top') && block.below().hasTag('v360:frustum' || 'v360:middle') && block.below().typeId === 'v360:pointed_icicle_block' && block.above().typeId !== 'v360:pointed_icicle_block') {
                block.setPermutation(base)
            }
            else if (block.hasTag('v360:top') && block.hasTag('v360:tip') && block.below().hasTag('v360:tip_merge') && block.below().hasTag('v360:bottom') && block.below().typeId === 'v360:pointed_icicle_block') {
                block.setPermutation(tip_merge)
            }
        },
        beforeOnPlayerPlace({ block, player }) {
            const { x, y, z } = block.location
            const tip = block.permutation.matches('v360:pointed_icicle_block', { 'v360:size': 0 })
            const tip_merge = block.permutation.matches('v360:pointed_icicle_block', { 'v360:size': 4 })
            if (player.isSneaking && block.above().hasTag('v360:top') && block.above().hasTag('v360:tip')) {
                system.run(() => {
                    block.setPermutation(tip)
                })
            }
            if (player.isSneaking && block.below().hasTag('v360:bottom') && block.below().hasTag('v360:tip')) {
                system.run(() => {
                    block.setPermutation(tip)
                })
            }
            if (block.above().hasTag('v360:top') && block.above().hasTag('v360:tip') && !player.isSneaking) {
                system.run(() => {
                    block.setPermutation(tip_merge)
                })
            }
            if (block.below().hasTag('v360:bottom') && block.below().hasTag('v360:tip') && !player.isSneaking) {
                system.run(() => {
                    block.setPermutation(tip_merge)
                })
            }
        }
    })
})
